/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannel {
    private SocketChannel socketChannel;
    private Selector sel;
    private SelectionKey sk;
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutSocketChannel(SocketAddress socketAddress, int n2, NetStatImpl netStatImpl) throws IOException {
        super(null);
        this.netStat = netStatImpl;
        this.scheduleInterrupt(n2);
        try {
            this.socketChannel = SocketChannel.open(socketAddress);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
    }

    void setNetStat(NetStatImpl netStatImpl) {
        this.netStat = netStatImpl;
    }

    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.connect(socketAddress);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        try {
            if (this.socketChannel == null) throw new IOException("Socket channel is closed");
            if (!this.socketChannel.isOpen()) {
                throw new IOException("Socket channel is closed");
            }
            if (this.soTimeout == 0) {
                try {
                    int n2 = this.socketChannel.read(byteBuffer);
                    if (this.netStat == null) return n2;
                    this.netStat.incrementBytesReceived(n2);
                    return n2;
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    throw new SocketTimeoutException("Socket read interrupted");
                }
            }
            if (this.sel == null) {
                this.sel = Selector.open();
            }
            this.socketChannel.configureBlocking(false);
            try {
                int n3 = this.socketChannel.read(byteBuffer);
                if (n3 != 0) {
                    int n4 = n3;
                    return n4;
                }
                this.sk = this.socketChannel.register(this.sel, 1);
                int n5 = this.sel.select(this.soTimeout);
                if (n5 <= 0) throw new SocketTimeoutException("Socket read timed out");
                if (!this.sk.isReadable()) throw new SocketTimeoutException("Socket read timed out");
                n3 = this.socketChannel.read(byteBuffer);
                if (n3 == 0) throw new SocketTimeoutException("Socket read timed out");
                if (this.netStat != null) {
                    this.netStat.incrementBytesReceived(n3);
                }
                int n6 = n3;
                return n6;
            }
            finally {
                if (this.sk != null) {
                    this.sk.cancel();
                    this.sel.selectNow();
                    this.sk = null;
                }
                if (this.socketChannel != null && this.socketChannel.isOpen()) {
                    this.socketChannel.configureBlocking(true);
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            try {
                Socket socket = this.socketChannel.socket();
                socket.sendUrgentData(33);
                this.disconnect();
                throw socketTimeoutException;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw socketTimeoutException;
        }
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout());
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int n2 = this.socketChannel.write(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    public Channel getAdapteeChannel() {
        return this.socketChannel;
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.socketChannel.getRemoteAddress();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.socketChannel.shutdownOutput();
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.socketChannel.shutdownInput();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        return this.socketChannel.setOption((SocketOption)socketOption, (Object)t2);
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.bind(socketAddress);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.socketChannel.supportedOptions();
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.socketChannel.getOption(socketOption);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        throw new IOException("Unsupported feature");
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        throw new IOException("Unsupported feature");
    }

    private void scheduleInterrupt(int n2) {
        if (n2 > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread());
        }
    }

    private void handleInterrupt() throws InterruptedIOException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new InterruptedIOException("Socket read timed out");
        }
        throw new InterruptedIOException("Operation interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
        if (this.sel != null && this.sel.isOpen()) {
            try {
                this.sel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }
}

