/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class FloatBinder
extends VarnumBinder {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    FloatBinder() {
    }

    void bind(OraclePreparedStatement oraclePreparedStatement, int n2, int n3, int n4, byte[] byArray, char[] cArray, short[] sArray, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) throws SQLException {
        byte[] byArray2 = byArray;
        int n11 = n7 + 1;
        double d2 = oraclePreparedStatement.parameterDouble[n4][n2];
        int n12 = 0;
        if (d2 == 0.0) {
            byArray2[n11] = -128;
            n12 = 1;
        } else if (d2 == Double.POSITIVE_INFINITY) {
            byArray2[n11] = -1;
            byArray2[n11 + 1] = 101;
            n12 = 2;
        } else if (d2 == Double.NEGATIVE_INFINITY) {
            byArray2[n11] = 0;
            n12 = 1;
        } else {
            long l2;
            int n13;
            int n14;
            boolean bl2;
            boolean bl3 = bl2 = d2 < 0.0;
            if (bl2) {
                d2 = -d2;
            }
            if ((n14 = ((n13 = (int)((l2 = Double.doubleToLongBits(d2)) >> 52 & 0x7FFL)) > 1023 ? 126 : 127) - (int)((double)(n13 - 1023) / 6.643856189774725)) < 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d2);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (n14 > 192) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d2);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (d2 > factorTable[n14]) {
                while (n14 > 0 && d2 > factorTable[--n14]) {
                }
            } else {
                while (n14 < 193 && d2 <= factorTable[n14 + 1]) {
                    ++n14;
                }
            }
            if (d2 == factorTable[n14]) {
                if (n14 < 65) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n14 > 192) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (bl2) {
                    byArray2[n11] = (byte)(62 - (127 - n14));
                    byArray2[n11 + 1] = 100;
                    byArray2[n11 + 2] = 102;
                    n12 = 3;
                } else {
                    byArray2[n11] = (byte)(192 + (128 - n14));
                    byArray2[n11 + 1] = 2;
                    n12 = 2;
                }
            } else {
                int n15;
                if (n14 < 64) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (n14 > 191) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + d2);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n16 = Float.floatToIntBits((float)d2);
                int n17 = n16 & 0x7FFFFF;
                int n18 = n16 >> 23 & 0xFF;
                char[] cArray2 = oraclePreparedStatement.digits;
                if (n18 == 0) {
                    while ((long)(n17 & 0x800000) == 0L) {
                        n17 <<= 1;
                        --n18;
                    }
                    n15 = 24 + n18;
                    ++n18;
                } else {
                    n17 |= 0x800000;
                    n15 = 24;
                }
                n12 = this.dtoa(byArray2, n11, d2, bl2, true, cArray2, n18 -= 127, (long)n17 << 29, n15);
            }
        }
        byArray2[n7] = (byte)n12;
        sArray[n10] = 0;
        sArray[n9] = (short)(n12 + 1);
    }
}

